/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "test_common.h"
#if !MX_OS_WINNT
#include <unistd.h>
#else
#include "mx_uni.h"
#endif

int main(int argc, char **argv)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  mx_endpoint_addr_t addr2;
  uint64_t nic_id;
  uint32_t eid;
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  char send_buff[80];
  char recv_buff[80];
  mx_status_t s1, s2;
  mx_request_t send_req;
  mx_request_t recv_req;
  uint32_t result;
  int c;

  int board_id = MX_ANY_NIC;
  int my_eid = MX_ANY_ENDPOINT;
  int read_only = 0;
  int issend = 0;
  
  while ((c = getopt(argc, argv, "b:e:rsn")) != EOF) switch(c) {
  case 'b':
    board_id = atoi(optarg);
    break;
  case 'e':
    my_eid = atoi(optarg);
    break;
  case 'r':
    read_only = 1;
    break;
  case 's':
    issend = 1;
    break;
  default:
    fprintf(stderr,"usage:loopback [ -b<num> ] [ -e <eid> ] [ -r ] [ -s ]\n");
    exit(1);
  }

  mx_init();
  mx_open_endpoint(board_id, my_eid, 0, NULL, 0, &ep);
  mx_set_error_handler(MX_ERRORS_ARE_FATAL);
  mx_get_endpoint_addr(ep, &addr);
  mx_decompose_endpoint_addr(addr, &nic_id, &eid);
  printf("my nic_id is %"PRIx64"\n", nic_id);
  printf("my endpoint_id is %hx\n", eid);
  mx_connect(ep, nic_id, eid, 0, MX_INFINITE, &addr2);

  strcpy(send_buff, "hello world");
  memset(recv_buff, 0, 80);

  send_seg.segment_ptr = read_only ? "hello world" : send_buff;
  send_seg.segment_length = strlen((char*)send_seg.segment_ptr)+1;
  recv_seg.segment_ptr = recv_buff;
  recv_seg.segment_length = 21;

  mx_irecv(ep, &recv_seg, 1, MAKE_MATCH(10, 11), MX_MATCH_MASK_NONE, NULL, &recv_req);
  (issend ? mx_issend : mx_isend)(ep, &send_seg, 1, addr, MAKE_MATCH(10, 11), NULL, &send_req);
  mx_wait(ep, &recv_req, MX_INFINITE, &s1, &result);
  mx_wait(ep, &send_req, MX_INFINITE, &s2, &result);
  printf("%s\n", recv_buff);

  mx_close_endpoint(ep);
  mx_finalize();

  return  0;
}
